#!/bin/sh
set -e

echo VMware ESXi 5.x Unlocker 1.2.0
echo ===============================
echo Copyright: Dave Parsons 2011-13

# Ensure we only use unmodified commands
export PATH=/bin:/sbin:/usr/bin:/usr/sbin

# Copy Unlocker to tmp
script_dir=$(dirname $0)
cp $script_dir/Unlocker.ESXi /tmp

# Make sure working files are removed
cd /tmp
rm -f darwin.tgz
rm -f darwin.vgz
rm -rf ./bin

# Patch the vmx files and place into bin folder
echo Patching files...
mkdir bin
cp /bin/vmx bin/
cp /bin/vmx-debug bin/
cp /bin/vmx-stats bin/
./Unlocker.ESXi bin/

# Ensure correct permissions are set
echo Setting permissions...
chmod 4555 bin/*

# Create the tar file for ESXi kernel
echo Creating darwin.tgz...
tar -czvf darwin.tgz bin/
vmtar -c darwin.tgz -v -o darwin.vgz

# Add entry to the boot configuration file
echo Adding darwin.tgz to boot.cfg...
BootModuleConfig.sh --add=darwin.vgz --verbose

# Clean up
rm -f Unlocker.ESXi
rm -f darwin.tgz
rm -f darwin.vgz
rm -rf ./bin
cd -

echo Please now reboot the host system!
